using System;
using System.Data;
using System.Collections;
using System.ComponentModel;
using System.Drawing;
using System.Windows.Forms;

namespace gov.va.med.vbecs.GUI
{
	/// <summary>
	/// Class DlgSelectDControl
	/// </summary>
	public class DlgSelectDControl : gov.va.med.vbecs.GUI.VbecsBaseForm
	{
		private BOL.Reagent _reagent;
		private DataTable _dtReagents;
		//
		private System.Windows.Forms.GroupBox grpImage;
		private System.Windows.Forms.PictureBox picImage;
		private System.Windows.Forms.GroupBox grpAntisera;
		private System.Windows.Forms.TextBox txtReagentType;
		private gov.va.med.vbecs.GUI.controls.ComboBoxLookup cmbLotNumber;
		private System.Windows.Forms.Label lblLotNumber;
		private System.Windows.Forms.Label lblAntisera;
		private System.Windows.Forms.TextBox txtExpirationDate;
		private System.Windows.Forms.Label lblExpirationDate;
		private System.Windows.Forms.TextBox txtManufacturer;
		private System.Windows.Forms.Label lblManufacturer;
		private System.Windows.Forms.Button btnCancel;
		private gov.va.med.vbecs.GUI.controls.VbecsButton btnOK;
		private System.Windows.Forms.GroupBox grpMessage;
		private System.Windows.Forms.Label lblMessage;
		private System.ComponentModel.IContainer components = null;

		/// <summary>
		/// Constructor
		/// </summary>
		public DlgSelectDControl()
		{
			// This call is required by the Windows Form Designer.
			InitializeComponent();

			SetComponentProperties();

			this.LoadReagents();
		}

		/// <summary>
		/// Clean up any resources being used.
		/// </summary>
		protected override void Dispose( bool disposing )
		{
			if( disposing )
			{
				if (components != null) 
				{
					components.Dispose();
				}
			}
			base.Dispose( disposing );
		}

		#region Designer generated code
		/// <summary>
		/// Required method for Designer support - do not modify
		/// the contents of this method with the code editor.
		/// </summary>
		private void InitializeComponent()
		{
			this.components = new System.ComponentModel.Container();
			System.Resources.ResourceManager resources = new System.Resources.ResourceManager(typeof(DlgSelectDControl));
			this.grpImage = new System.Windows.Forms.GroupBox();
			this.picImage = new System.Windows.Forms.PictureBox();
			this.grpAntisera = new System.Windows.Forms.GroupBox();
			this.txtReagentType = new System.Windows.Forms.TextBox();
			this.cmbLotNumber = new gov.va.med.vbecs.GUI.controls.ComboBoxLookup(this.components);
			this.lblLotNumber = new System.Windows.Forms.Label();
			this.lblAntisera = new System.Windows.Forms.Label();
			this.txtExpirationDate = new System.Windows.Forms.TextBox();
			this.lblExpirationDate = new System.Windows.Forms.Label();
			this.txtManufacturer = new System.Windows.Forms.TextBox();
			this.lblManufacturer = new System.Windows.Forms.Label();
			this.btnCancel = new System.Windows.Forms.Button();
			this.btnOK = new gov.va.med.vbecs.GUI.controls.VbecsButton();
			this.grpMessage = new System.Windows.Forms.GroupBox();
			this.lblMessage = new System.Windows.Forms.Label();
			this.grpImage.SuspendLayout();
			this.grpAntisera.SuspendLayout();
			this.grpMessage.SuspendLayout();
			this.SuspendLayout();
			// 
			// vbecsLogo1
			// 
			this.vbecsLogo1.Name = "vbecsLogo1";
			this.vbecsLogo1.Size = new System.Drawing.Size(344, 30);
			this.vbecsLogo1.Title = "Select D Control";
			// 
			// lblRequiredField
			// 
			this.lblRequiredField.Location = new System.Drawing.Point(0, 225);
			this.lblRequiredField.Name = "lblRequiredField";
			// 
			// grpImage
			// 
			this.grpImage.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
				| System.Windows.Forms.AnchorStyles.Left)));
			this.grpImage.Controls.Add(this.picImage);
			this.grpImage.Location = new System.Drawing.Point(4, 32);
			this.grpImage.Name = "grpImage";
			this.grpImage.Size = new System.Drawing.Size(56, 172);
			this.grpImage.TabIndex = 9;
			this.grpImage.TabStop = false;
			// 
			// picImage
			// 
			this.picImage.Image = ((System.Drawing.Image)(resources.GetObject("picImage.Image")));
			this.picImage.Location = new System.Drawing.Point(4, 12);
			this.picImage.Name = "picImage";
			this.picImage.Size = new System.Drawing.Size(45, 45);
			this.picImage.SizeMode = System.Windows.Forms.PictureBoxSizeMode.AutoSize;
			this.picImage.TabIndex = 0;
			this.picImage.TabStop = false;
			// 
			// grpAntisera
			// 
			this.grpAntisera.Anchor = ((System.Windows.Forms.AnchorStyles)((((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
				| System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.grpAntisera.Controls.Add(this.txtReagentType);
			this.grpAntisera.Controls.Add(this.cmbLotNumber);
			this.grpAntisera.Controls.Add(this.lblLotNumber);
			this.grpAntisera.Controls.Add(this.lblAntisera);
			this.grpAntisera.Controls.Add(this.txtExpirationDate);
			this.grpAntisera.Controls.Add(this.lblExpirationDate);
			this.grpAntisera.Controls.Add(this.txtManufacturer);
			this.grpAntisera.Controls.Add(this.lblManufacturer);
			this.grpAntisera.Location = new System.Drawing.Point(64, 84);
			this.grpAntisera.Name = "grpAntisera";
			this.grpAntisera.Size = new System.Drawing.Size(276, 120);
			this.grpAntisera.TabIndex = 0;
			this.grpAntisera.TabStop = false;
			// 
			// txtReagentType
			// 
			this.txtReagentType.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.txtReagentType.Location = new System.Drawing.Point(80, 20);
			this.txtReagentType.Name = "txtReagentType";
			this.txtReagentType.ReadOnly = true;
			this.txtReagentType.Size = new System.Drawing.Size(188, 20);
			this.txtReagentType.TabIndex = 3;
			this.txtReagentType.Text = "";
			// 
			// cmbLotNumber
			// 
			this.cmbLotNumber.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.cmbLotNumber.Interval = 500;
			this.cmbLotNumber.Location = new System.Drawing.Point(80, 44);
			this.cmbLotNumber.MaxLength = 15;
			this.cmbLotNumber.Name = "cmbLotNumber";
			this.cmbLotNumber.Size = new System.Drawing.Size(188, 22);
			this.cmbLotNumber.TabIndex = 0;
			this.cmbLotNumber.SelectedIndexChanged += new System.EventHandler(this.LotNumberChanged);
			// 
			// lblLotNumber
			// 
			this.lblLotNumber.Location = new System.Drawing.Point(4, 44);
			this.lblLotNumber.Name = "lblLotNumber";
			this.lblLotNumber.Size = new System.Drawing.Size(88, 20);
			this.lblLotNumber.TabIndex = 2;
			this.lblLotNumber.Text = "Lot Number*";
			this.lblLotNumber.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
			// 
			// lblAntisera
			// 
			this.lblAntisera.Location = new System.Drawing.Point(4, 20);
			this.lblAntisera.Name = "lblAntisera";
			this.lblAntisera.Size = new System.Drawing.Size(88, 20);
			this.lblAntisera.TabIndex = 0;
			this.lblAntisera.Text = "Reagent Type";
			this.lblAntisera.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
			// 
			// txtExpirationDate
			// 
			this.txtExpirationDate.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.txtExpirationDate.Location = new System.Drawing.Point(80, 92);
			this.txtExpirationDate.Name = "txtExpirationDate";
			this.txtExpirationDate.ReadOnly = true;
			this.txtExpirationDate.Size = new System.Drawing.Size(188, 20);
			this.txtExpirationDate.TabIndex = 2;
			this.txtExpirationDate.Text = "";
			// 
			// lblExpirationDate
			// 
			this.lblExpirationDate.Location = new System.Drawing.Point(4, 92);
			this.lblExpirationDate.Name = "lblExpirationDate";
			this.lblExpirationDate.Size = new System.Drawing.Size(84, 20);
			this.lblExpirationDate.TabIndex = 56;
			this.lblExpirationDate.Text = "Expires";
			this.lblExpirationDate.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
			// 
			// txtManufacturer
			// 
			this.txtManufacturer.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.txtManufacturer.Location = new System.Drawing.Point(80, 68);
			this.txtManufacturer.Name = "txtManufacturer";
			this.txtManufacturer.ReadOnly = true;
			this.txtManufacturer.Size = new System.Drawing.Size(188, 20);
			this.txtManufacturer.TabIndex = 1;
			this.txtManufacturer.Text = "";
			// 
			// lblManufacturer
			// 
			this.lblManufacturer.Location = new System.Drawing.Point(4, 68);
			this.lblManufacturer.Name = "lblManufacturer";
			this.lblManufacturer.Size = new System.Drawing.Size(88, 20);
			this.lblManufacturer.TabIndex = 54;
			this.lblManufacturer.Text = "Manufacturer";
			this.lblManufacturer.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
			// 
			// btnCancel
			// 
			this.btnCancel.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Right)));
			this.btnCancel.DialogResult = System.Windows.Forms.DialogResult.Cancel;
			this.btnCancel.Location = new System.Drawing.Point(264, 208);
			this.btnCancel.Name = "btnCancel";
			this.btnCancel.TabIndex = 2;
			this.btnCancel.Text = "&Cancel";
			this.btnCancel.Click += new System.EventHandler(this.btnCancel_Click);
			// 
			// btnOK
			// 
			this.btnOK.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Right)));
			this.btnOK.EnabledButton = false;
			this.btnOK.Font = new System.Drawing.Font("Arial", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.btnOK.Image = ((System.Drawing.Image)(resources.GetObject("btnOK.Image")));
			this.btnOK.Location = new System.Drawing.Point(184, 208);
			this.btnOK.Name = "btnOK";
			this.btnOK.Size = new System.Drawing.Size(75, 23);
			this.btnOK.TabIndex = 1;
			this.btnOK.Click += new System.EventHandler(this.btnOK_Click);
			this.btnOK.MouseHover += new System.EventHandler(this.btnOK_MouseHover);
			// 
			// grpMessage
			// 
			this.grpMessage.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.grpMessage.Controls.Add(this.lblMessage);
			this.grpMessage.Location = new System.Drawing.Point(64, 32);
			this.grpMessage.Name = "grpMessage";
			this.grpMessage.Size = new System.Drawing.Size(276, 52);
			this.grpMessage.TabIndex = 3;
			this.grpMessage.TabStop = false;
			// 
			// lblMessage
			// 
			this.lblMessage.Anchor = ((System.Windows.Forms.AnchorStyles)((((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
				| System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.lblMessage.Font = new System.Drawing.Font("Tahoma", 8.25F, System.Drawing.FontStyle.Bold, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.lblMessage.Location = new System.Drawing.Point(8, 12);
			this.lblMessage.Name = "lblMessage";
			this.lblMessage.Size = new System.Drawing.Size(260, 28);
			this.lblMessage.TabIndex = 0;
			this.lblMessage.Text = "Enter the lot number of the Anti-D Control reagent to be used in Weak D testing.";
			this.lblMessage.TextAlign = System.Drawing.ContentAlignment.MiddleCenter;
			// 
			// DlgSelectDControl
			// 
			this.AcceptButton = this.btnOK;
			this.AutoScaleBaseSize = new System.Drawing.Size(5, 13);
			this.CancelButton = this.btnCancel;
			this.ClientSize = new System.Drawing.Size(344, 241);
			this.Controls.Add(this.grpMessage);
			this.Controls.Add(this.grpImage);
			this.Controls.Add(this.grpAntisera);
			this.Controls.Add(this.btnCancel);
			this.Controls.Add(this.btnOK);
			this.hlphelpChm.SetHelpKeyword(this, "Unit_Antigen_Typing.htm");
			this.hlphelpChm.SetHelpNavigator(this, System.Windows.Forms.HelpNavigator.Topic);
			this.MaximizeBox = false;
			this.MinimizeBox = false;
			this.MinimumSize = new System.Drawing.Size(352, 268);
			this.Name = "DlgSelectDControl";
			this.RequiredFieldsLabel = true;
			this.hlphelpChm.SetShowHelp(this, true);
			this.Text = "VBECS - Select D Control";
			this.Controls.SetChildIndex(this.vbecsLogo1, 0);
			this.Controls.SetChildIndex(this.lblRequiredField, 0);
			this.Controls.SetChildIndex(this.btnOK, 0);
			this.Controls.SetChildIndex(this.btnCancel, 0);
			this.Controls.SetChildIndex(this.grpAntisera, 0);
			this.Controls.SetChildIndex(this.grpImage, 0);
			this.Controls.SetChildIndex(this.grpMessage, 0);
			this.grpImage.ResumeLayout(false);
			this.grpAntisera.ResumeLayout(false);
			this.grpMessage.ResumeLayout(false);
			this.ResumeLayout(false);

		}
		#endregion

		/// <summary>
		/// Get AntiDControlGuid
		/// </summary>
		public Guid AntiDControlGuid
		{
			get
			{
				return this._reagent.ReagentGuid;
			}
		}

		private void SetComponentProperties()
		{
			this.vbecsLogo1.Title = this.Text.Replace("VBECS - ","");
			// CR 2693
			// hlpHelp
			// 
			this.hlpHelp.HelpNamespace = Environment.CurrentDirectory+"\\VBECS.chm";
			// 
			// hlphelpChm
			// 
			this.hlphelpChm.HelpNamespace = Environment.CurrentDirectory+"\\VBECS.chm";
			//
			this.SetThisHelpFile(this, Common.StrRes.HelpFiles.UC041.DlgSelectDControl());
			//
			this.btnOK.SetToolTip(Common.StrRes.Tooltips.UC056.ChooseLotNumber().ResString);
			this.btnOK.EnabledButton = false;
			//
			this.SetThisToolTip(this.btnCancel,Common.StrRes.Tooltips.Common.Cancel());
		}

		private void LoadReagents()
		{
			this.txtReagentType.Text = "Anti-D Control";
			//
			this._dtReagents = BOL.Reagent.GetReagentsByType(Common.LogonUser.LogonUserDivisionCode, (int)Common.WeakDTestReagents.AntiDControl);

			foreach(DataRow drReagent in this._dtReagents.Rows)
			{
				this.cmbLotNumber.Items.Add(drReagent[Common.VbecsTables.Reagent.LotNumber].ToString());
			}
		}

		private void LotNumberChanged(object sender, System.EventArgs e)
		{
			if (this.cmbLotNumber.SelectedIndex > -1)
			{
				this._reagent = new BOL.Reagent(this._dtReagents.Rows[this.cmbLotNumber.SelectedIndex]);
				//
				this.txtExpirationDate.Text = Common.VBECSDateTime.FormatDateTimeString(this._reagent.LotExpirationDate);
				this.txtManufacturer.Text = this._reagent.ReagentManufacturerName;
				this.btnOK.EnabledButton = true;
			}
			else
			{
				this._reagent = new BOL.Reagent();
				//
				this.txtExpirationDate.Text = "";
				this.txtManufacturer.Text = "";
				this.btnOK.EnabledButton = false;;
			}
		}

		private void btnOK_MouseHover(object sender, System.EventArgs e)
		{
			if (this.cmbLotNumber.SelectedIndex>-1)
			{
				this.btnOK.SetToolTip(Common.StrRes.Tooltips.Common.OKToContinue().ResString);
			}
			else
			{
				this.btnOK.SetToolTip(Common.StrRes.Tooltips.UC056.ChooseLotNumber().ResString);
			}
		}

		private void btnOK_Click(object sender, System.EventArgs e)
		{
			this.DialogResult = DialogResult.OK;
			this.Close();
		}

		private void btnCancel_Click(object sender, System.EventArgs e)
		{
			this.DialogResult = DialogResult.Cancel;
			this.Close();
		}
	}
}

